Imports MySql.Data
Imports MySql.Data.MySqlClient
Imports System.Data

Partial Class Select_MySQL
    Inherits System.Web.UI.Page
    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        ' When this page load we first check to see that the keyword parameter not is blank ("")

        If Not Request.QueryString("keyword") = "" Then
            HiddenKeyWord.Value = Request.QueryString("keyword")

            ' ////////////////////// Navigation with previous and next links /////////////////////////
            ' We select data to a repeater control and split up the datalist in
            ' pages with previous and next links for navigation.

            Try
                Dim ConnString As String = ConfigurationManager.ConnectionStrings("ConnectionString").ToString()
                Dim sql As String = "SELECT * FROM content WHERE MetaKeywords LIKE @Keywords ORDER BY Name ASC"

                ' The Using block is used to call dispose (close) automatically even if there are an exception.
                Using cn As New MySqlConnection(ConnString), _
                      sad As New MySqlDataAdapter(), _
                      cmd As New MySqlCommand(sql, cn)
                    cmd.Parameters.Add("@Keywords", MySqlDbType.VarChar, 100).Value = "%" + HiddenKeyWord.Value + "%"

                    cn.Open()
                    sad.SelectCommand = cmd

                    ' The Using block is used to call dispose (close) automatically even if there are an exception.
                    Using dt As DataTable = New DataTable()
                        sad.Fill(dt)

                        ' Populate the repeater control with the datatable 
                        Dim objPds As PagedDataSource = New PagedDataSource()
                        objPds.DataSource = dt.DefaultView

                        ' Indicate that the data should be paged 
                        objPds.AllowPaging = True

                        ' Set the pagesize 
                        objPds.PageSize = 10

                        ' The current page (curpage) is declared as an integer
                        Dim curpage As Int32

                        ' We set the page number for the current page from the page parameter in the url
                        ' or to 1 if there are no page parameter in the url

                        If Not IsNothing(Request.QueryString("page")) Then
                            curpage = Convert.ToInt32(Request.QueryString("page"))
                        Else
                            curpage = 1
                        End If

                        ' The current page index is equal to the current page minus 1 and we need to no this
                        ' to show the right page to the user.

                        objPds.CurrentPageIndex = curpage - 1

                        ' We set the text in the middle to show the current pagenumber and the last pagenumber

                        lblCurrentPage.Text = "| Page: " + curpage.ToString() + " of " + objPds.PageCount.ToString() + " |"

                        ' This is code for the link to the previous page, we don't show this link on the first page

                        If Not objPds.IsFirstPage Then
                            lnkPrev.Visible = True
                            lnkPrev.NavigateUrl = "~/Pages-in-repeater.aspx?" + "keyword=" + HiddenKeyWord.Value + "&page=" + CStr(curpage - 1)
                        End If

                        ' This is code for the link to the next page, we don't show this link on the last page

                        If Not objPds.IsLastPage Then
                            lnkNext.Visible = True
                            lnkNext.NavigateUrl = "~/Pages-in-repeater.aspx?" + "keyword=" + HiddenKeyWord.Value + "&page=" + CStr(curpage + 1)
                        End If

                        ' This code is used to bind data to the repeater control

                        ContentListRepeater.DataSource = objPds
                        ContentListRepeater.DataBind()

                    End Using

                End Using
            Catch ex As Exception
                Response.Write(ex.Message)
            End Try

            ' ////////////////////// Navigation with number links /////////////////////////
            ' We select data to a repeater control and split up the datalist in
            ' pages with number links for navigation.

            Try
                Dim ConnString As String = ConfigurationManager.ConnectionStrings("ConnectionString").ToString()
                Dim sql As String = "SELECT * FROM content WHERE MetaKeywords LIKE @Keywords ORDER BY Name ASC"

                ' The Using block is used to call dispose (close) automatically even if there are an exception.
                Using cn As New MySqlConnection(ConnString), _
                      sad As New MySqlDataAdapter(), _
                      cmd As New MySqlCommand(sql, cn)
                    cmd.Parameters.Add("@Keywords", MySqlDbType.VarChar, 100).Value = "%" + HiddenKeyWord.Value + "%"

                    cn.Open()
                    sad.SelectCommand = cmd

                    ' The Using block is used to call dispose (close) automatically even if there are an exception.
                    Using dt As DataTable = New DataTable()
                        sad.Fill(dt)

                        ' Populate the repeater control with the datatable 
                        Dim objPds As PagedDataSource = New PagedDataSource()
                        objPds.DataSource = dt.DefaultView

                        ' Indicate that the data should be paged 
                        objPds.AllowPaging = True

                        ' Set the pagesize 
                        objPds.PageSize = 10

                        ' The current page (curpage) is declared as an integer
                        Dim curpage As Int32

                        ' We set the page number for the current page from the page parameter in the url
                        ' or to 1 if there are no page parameter in the url

                        If Not IsNothing(Request.QueryString("page")) Then
                            curpage = Convert.ToInt32(Request.QueryString("page"))
                        Else
                            curpage = 1
                        End If

                        ' The current page index is equal to the current page minus 1 and we need to no this
                        ' to show the right page to the user.

                        objPds.CurrentPageIndex = curpage - 1

                        ' This code is to set the links for the pages in the repeater and the links are
                        ' made up of pagenumbers. We set one link for each page in a literal control.

                        Dim NumberOfPages As Integer = objPds.PageCount - 1

                        For i As Integer = 0 To NumberOfPages
                            litPages.Text += " <a href=""" & "Pages-in-repeater.aspx?keyword=" & HiddenKeyWord.Value & "&amp;page=" & (i + 1) & """>" & (i + 1) & "</a>"
                        Next i

                        ' This code binds the data to the repeater control

                        ListRepeater2.DataSource = objPds
                        ListRepeater2.DataBind()

                    End Using

                End Using
            Catch ex As Exception
                Response.Write(ex.Message)
            End Try
        End If
    End Sub

    Protected Sub btnGetKeyword_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnGetKeyword.Click

        ' When the user clicks the "Get keyword" button we send the parameter for the keyword in the url

        Response.Redirect("Pages-in-repeater.aspx?keyword=" + txtKeyword.Text)

    End Sub

    Protected Function GenerateURL(ByVal Contentname As Object) As String

        'Create SEO Friendly URL for each content link
        Dim strConUrl As String = "~/article/" & Contentname & ".aspx"

        Return strConUrl
    End Function

    
End Class
